// TODO: revert tag hide-menu to show menu
define([
    'underscore',
    'backbone',
    'App',
    'Vent',
    'marionette',
    'text!modules/page/main.html',
    'HeaderView',

    'modules/page/user-menu/user-menu-view',
    'modules/page/footer/footer-view',
    'modules/loading-spinner/loading-spinner',
    'modules/page/content/aria-live-view',
    'modules/crisis/modal',
],
function (
    _,
    Backbone,
    app,
    vent,
    Marionette,
    mainTemplate,
    HeaderView,
    UserMenuView,
    FooterView,
    loadingSpinner,
    AriaLiveView,
    CrisisModal
) {
    'use strict';

    return Backbone.Marionette.View.extend({
        el: '#main',
        template: _.template(mainTemplate),
        regions: {
            header: '#header',
            content: {el: '.content'},
            footer: '.footer',
            menu: '#menu',
            userMenu: '#user-menu',
            ariaLiveRegion: '.content-live-region',
        },

        events: {
            'click #crisis-button': 'showCrisisModal',
        },

        initialize: function(options) {
            if (_.isUndefined(this.model)) {
                this.model = new Backbone.Model({hasAppMenu: true});
            }
            this.listenTo(vent, 'show:session:expired', this.clearContentRegion);
        },
        // has to be onRender because this is app's layout
        // (no region that will call its onShow)
        onRender: function() {
            var header = this.getRegion('header');
            var footer = this.getRegion('footer');
            var debounceTime = 900;
            var userMenuOptions;
            var content = this.getRegion('content');

            /* listeners */
            this.listenTo(content, 'show', this.onShowContent);

            // to get window height to calculate post-minification
            this.listenToOnce(content, 'show', function() {
                $(window).resize();
                app.showingContent.resolve(); // show server errors
            });
            $(window).on('throttledresize.mainview orientationchange.mainview',
                _.debounce(this.resizeContentAndMenus.bind(this), debounceTime));

            // when modal opens, add aria-hidden to #main
            $(document).on('popupafteropen.modal', '.ui-popup', function() {
                this.$el.attr('aria-hidden', true);
                $('.ui-popup').one('popupafterclose.modal', function() {
                    this.$el.attr('aria-hidden', false);
                }.bind(this));
            }.bind(this));

            $(document).on('panelclose.appmenu', '#menu', function() {
                this.focusOnHeader(this.content.currentView);
            }.bind(this));
            /* end listeners */


            header.show(new HeaderView());
            userMenuOptions = {
                panel: this.$el.find('#user-menu'),
                button: this.$el.find('#user-menu-btn'),
            };
            // menu
            this.listenTo(app.userSession, 'sync', function() {
                var userMenu = this.getRegion('userMenu');
                if (!app.userSession.isLoggedIn()) {
                    userMenuOptions.isShowingOnlyLaunchpad = true;
                }
                userMenu.show(new UserMenuView(userMenuOptions));
            });

            // footer
            footer.show(new FooterView());

            this.showAriaLiveLoadingView();

            $.mobile.initializePage();

        },

        firstTimeShowCrisisModal: function() {
            if (_.isNull(localStorage.getItem('notFirstLogin'))) {
                this.showCrisisModal();
                localStorage.setItem('notFirstLogin', true);
            }
        },
        showAriaLiveLoadingView: function() {
            var ariaLiveRegion = this.getRegion('ariaLiveRegion');
            var debounceTime = 100;

            loadingSpinner.register();

            if (!this.isDestroyed() && !this.ariaLiveView) {
                this.ariaLiveView = new AriaLiveView({model: new Backbone.Model({response: ''})});

                ariaLiveRegion.show(this.ariaLiveView);
                loadingSpinner.radio.on('show', _.debounce(function() {
                    var loadingSpinnerText = $('.loading-spinner').text()
                        .trim();
                    this.ariaLiveView.model.set('response', loadingSpinnerText);
                }, debounceTime, {leading: true, trailing: false}), this);
                loadingSpinner.radio.on('hide', _.debounce(function() {
                    this.ariaLiveView.model.set('response', '');
                }, debounceTime, {leading: false, trailing: true}), this);
            }

            this.listenToOnce(this.ariaLiveView, 'destroy', function() {
                loadingSpinner.radio.off('show', undefined, this);
                loadingSpinner.radio.off('hide', undefined, this);
            });
        },
        onDestroy: function() {
            $(window).off('throttledresize.mainview orientationchange.mainview');
            $(document).off('popupafteropen.modal');
            $(document).off('panelclose.appmenu');
        },
        // renderAppMenu: function() {
        //     if (this.model.get('hasAppMenu')) {
        //         this.menu.show( new AppMenuView() );
        //         this.$el.find("#menu-btn").show();
        //     } else {
        //         this.menu.empty();
        //         this.$el.find("#menu-btn").hide();
        //     }
        // },
        onShowContent: function(view) {
            this.$el.find('#main-content').scrollTop(0);
            if ($.active === 0) {
                this.focusOnHeader(view);
            } else {
                this.listenToOnce(this.ariaLiveView.model, 'change:response', function(model) {
                    if (model.get('response') === '' && !view.isDestroyed()) {
                        this.focusOnHeader(view);
                    }
                });
            }
        },
        // TODO: create object with {focusOnHeader} to be extended by any marionette view
        focusOnHeader: function(view) {
            var primaryContentHeader = view ? view.$el.find('.primary-header h2').first() : null;

            if (this.$el.attr('aria-hidden') !== 'true') {
                if (primaryContentHeader && primaryContentHeader.text() !== '') {
                    primaryContentHeader.focus();
                } else {
                    $('#header .ui-title').focus();
                }
            }
        },
        resizeContentAndMenus: function() {
            var $header = this.$el.find('header');
            var headerCompleteHeight = $header.outerHeight() + $header.offset().top;
            var appHeaderCompleteHeight = $header.outerHeight();
            var $footer = this.$el.find('.footer');
            var footerHeight = $footer.is(':visible') ? $footer.outerHeight() : 0;
            var theContainer = $(window);
            var $mainId = this.$el.find('#main-content');
            var $menuPanel = this.$el.find('.menu-panel');

            $menuPanel.css({
                'top': appHeaderCompleteHeight + 'px',
                'bottom': '0',
            });

            // Issue with AppleWebKit 536.26 - need to use document instead of window.
            if (navigator.userAgent.indexOf('AppleWebKit/536.26') > -1) {
                theContainer = $(document);
            }

            $mainId.css({'height': (theContainer.height() - headerCompleteHeight - footerHeight) + 'px'});
        },
        clearContentRegion: function() {
            this.getRegion('content').reset();
        },

        showCrisisModal: function() {
            var crisisModal = new CrisisModal({elAfterClose: '#crisis-button'});
            crisisModal.openPopup();
        },
    });
}
);
